(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18210,        683]*)
(*NotebookOutlinePosition[     19113,        713]*)
(*  CellTagsIndexPosition[     19069,        709]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Cauchy-Euler Equations"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Differential equations of the form \n\t\t",
  Cell[BoxData[
      \(\(L[y]\)[x] = \[Sum]\+\(k = 0\)\%n a[k]\ x\^k\ \(y\^\((k)\)\)[x] == 
          0\)]],
  "\nare called Cauchy-Euler equations after two of the pre-eminent \
mathematicians of all time who studied them. When a[n] != 0, the equation is \
of ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox["n", 
          StyleBox["th",
            FontVariations->{"Underline"->True}]], TraditionalForm]]],
  " order. The key to correctly identifying Cauchy-Euler equations is that \
the power of x in the coefficient of each term exactly matches the order of \
the derivative for that term. Missing terms are considered to have the \
correct form.\n\nThe built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " can solve those Cauchy-Euler for which the characteristic equation can be \
solved by ",
  StyleBox["Solve",
    FontWeight->"Bold"],
  ". This notebook assists you in understanding the theory by enabling you to \
execute those steps the theory proposes."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Solution Procedure (Theory)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "The solution is found by observing that\n\t\t",
  StyleBox["(x^i)*D[x^r,{x,i}]===c[r]*x^r,",
    FontWeight->"Bold"],
  "\nwhere c[r] is a polynomial in r, so that\n\t\t",
  StyleBox["L[x^r]\t=Sum[a[i]*(x^i)*D[x^r,{x,i}], {i,0,n}]\n\t\t\t==p[r]*x^r\n\
\t\t\t==0\n",
    FontWeight->"Bold"],
  "when p[r]==0. This is the characteristic equation for Cauchy-Euler \
differential operators. When the roots are distinct, r1, r2, . . . , rn, then \
the complete solution is\n\t\t\t",
  StyleBox["y[x] = c1*x^r1 + c2*x^r2 + . . . + cn*x^rn.",
    FontWeight->"Bold"],
  "\nIf rk is a root of multiplicity m, then the solution corresponding to rk \
are\n\t\t\t",
  StyleBox["yk[x]= x^rk*(d1 + d2*Log[x]+ . . . + d[k-1]*Log[x]^(k-1)).",
    FontWeight->"Bold"],
  "\nIf r = a ",
  StyleBox["\[PlusMinus] ",
    FontFamily->"Chicago"],
  "b I is complex the corresponding real solutions are\n\t\t\t",
  StyleBox["y[x]= (x^a)*(c1 Cos[b*Log[x]] +c2*Sin[b*Log[x]]).",
    FontWeight->"Bold"],
  "\nRepeated complex roots are treated analogously to the way they were in \
the constant coefficients case."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example (Distinct Roots)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Note how we follow the theory step-by-step. Here is the operator."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(CEOp[x_, y_]\), "=", 
      RowBox[{
        RowBox[{\(x\^3\), " ", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{"2", " ", \(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{"2", " ", "x", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(8\ y[x]\)}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(8\ y[x]\), "-", 
      RowBox[{"2", " ", "x", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "-", 
      RowBox[{"2", " ", \(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(x\^3\), " ", 
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData["This is the function which we will substitute."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ySub[x_] = x\^r\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\^r\)], "Output"]
}, Closed]],

Cell[TextData["Here is our characteristic polynomial."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(poly[r_] = Coefficient[Expand[CEOp[x, ySub]], x\^r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(8 + 2\ r - 5\ r\^2 + r\^3\)], "Output"]
}, Closed]],

Cell[TextData["Here are the distinct roots (in rule form)."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[poly[r] == 0, r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] \(-1\)}, {r \[Rule] 2}, {r \[Rule] 4}}\)], "Output"]
}, Closed]],

Cell[TextData["Capture the roots."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(roots = r /. Solve[poly[r] == 0, r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-1\), 2, 4}\)], "Output"]
}, Closed]],

Cell[TextData["Produce the complete solution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[x_] = x\^roots . {c1, c2, c3}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c1\/x + c2\ x\^2 + c3\ x\^4\)], "Output"]
}, Closed]],

Cell[TextData["Check the solution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[CEOp[x, s] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " to get the solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[CEOp[x, y] == 0, y[x], x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{y[x] \[Rule] C[1]\/x + x\^2\ C[2] + x\^4\ C[3]}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example (Repeated Roots)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Note how we follow the theory step-by-step. Here is the operator."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(CEOp[x_, y_]\), "=", 
      RowBox[{
        RowBox[{\(x\^4\), " ", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((4)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"9", " ", \(x\^3\), " ", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((3)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"10", " ", \(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "-", 
        RowBox[{"30", " ", "x", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "-", \(24\ y[x]\)}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(\(-24\)\ y[x]\), "-", 
      RowBox[{"30", " ", "x", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"10", " ", \(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"9", " ", \(x\^3\), " ", 
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(x\^4\), " ", 
        RowBox[{
          SuperscriptBox["y", 
            TagBox[\((4)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData["This is the function which we will substitute."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ySub[x_] = x\^r\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\^r\)], "Output"]
}, Closed]],

Cell[TextData["Here is our characteristic polynomial."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(poly[r_] = Coefficient[Expand[CEOp[x, ySub]], x\^r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-24\) - 28\ r - 6\ r\^2 + 3\ r\^3 + r\^4\)], "Output"]
}, Closed]],

Cell[TextData["Here are the roots (in rule form)."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[poly[r] == 0, r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] \(-2\)}, {r \[Rule] \(-2\)}, {r \[Rule] \(-2\)}, {r \[Rule] 
          3}}\)], "Output"]
}, Closed]],

Cell[TextData["Capture the roots."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(roots = r /. Solve[poly[r] == 0, r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-2\), \(-2\), \(-2\), 3}\)], "Output"]
}, Closed]],

Cell[TextData[
"Produce the complete solution. Notice the way to account for the triple \
root."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[x_] = x\^roots . {c1, c2, c3\ Log[x], c4\ Log[x]\^2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(c1\/x\^2 + c2\/x\^2 + \(c3\ Log[x]\)\/x\^2 + 
      c4\ x\^3\ Log[x]\^2\)], "Output"]
}, Closed]],

Cell[TextData["Check the solution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[CEOp[x, s] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(50\ c4\ x\^3\ \((3 + 5\ Log[x])\) == 0\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " to get the solution."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[CEOp[x, y] == 0, y[x], x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{y[x] \[Rule] 
          C[1]\/x\^2 + 
            x\^3\ C[4] + \(C[2]\ Log[x]\)\/x\^2 + \(C[3]\ Log[x]\^2\)\/x\^2}}\
\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Example (Complex Roots)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["\<\
Note how we follow the theory step-by-step. Here is the operator.\
\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(CEOp[x_, y_]\), "=", 
      RowBox[{
        RowBox[{\(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["y", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{"5", " ", "x", " ", 
          RowBox[{
            SuperscriptBox["y", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(29\ y[x]\)}]}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(29\ y[x]\), "+", 
      RowBox[{"5", " ", "x", " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["y", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData["This is the function which we will substitute."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(ySub[x_] = x\^r\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(x\^r\)], "Output"]
}, Closed]],

Cell[TextData["Here is our characteristic polynomial."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(poly[r_] = Coefficient[Expand[CEOp[x, ySub]], x\^r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(29 + 4\ r + r\^2\)], "Output"]
}, Closed]],

Cell[TextData["Here are the distinct roots (in rule form)."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[poly[r] == 0, r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] \(-2\) - 5\ \[ImaginaryI]}, {r \[Rule] \(-2\) + 
            5\ \[ImaginaryI]}}\)], "Output"]
}, Closed]],

Cell[TextData["Capture the first root."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(CpxRoot = 
      r /. \(Solve[poly[r] == 0, 
            r]\)\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-2\) - 5\ \[ImaginaryI]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = Re[CpxRoot]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-2\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = Im[CpxRoot]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-5\)\)], "Output"]
}, Closed]],

Cell[TextData["Produce the complete solution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[x_] = x\^a\ {Cos[b\ Log[x]], Sin[b\ Log[x]]} . {c1, c2}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(c1\ Cos[5\ Log[x]] - c2\ Sin[5\ Log[x]]\)\/x\^2\)], "Output"]
}, Closed]],

Cell[TextData["Check the solution."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[CEOp[x, s] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[
"The solution can be found more directly, but more obscurely by:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(ComplexExpand[x\^CpxRoot] /. {Arg[x] \[Rule] 0, 
        Abs[x] \[Rule] x}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(Cos[\(5\ Log[x\^2]\)\/2]\/x\^2 - \(\[ImaginaryI]\ Sin[\(5\ \
Log[x\^2]\)\/2]\)\/x\^2\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[x_] = 
      CoefficientList[% /. \(-I\) \[Rule] t, t] . {c1, c2} // 
        Simplify\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(c1\ Cos[\(5\ Log[x\^2]\)\/2] + c2\ Sin[\(5\ \
Log[x\^2]\)\/2]\)\/x\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Using ",
  StyleBox["DSolve",
    FontWeight->"Bold"],
  " is most direct:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[CEOp[x, y] == 0, y[x], x]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{y[
            x] \[Rule] \(C[2]\ Cos[5\ Log[x]]\)\/x\^2 + \(C[1]\ Sin[5\ \
Log[x]]\)\/x\^2}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Comments"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "To solve a Cauchy-Euler equation manually with the aid of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " you have to handle the various cases yourself. Gather the various \
repeated real root groups together. Do the same for repeated complex root \
groups. Then treat these as was done in the examples above. Finally, add all \
of your solution-groups together to make the complete solution. Be certain to \
keep the arbitrary constants unique throughout, so that the final solution \
has  n  different constants in it. If you fail to have enough, you will be \
unable to find a solution which meets certain initial conditions. (This is a \
hint that you do not have a complete solution.)\n\nVersions of ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  " from 2.0 onward can correctly solve Cauchy-Euler differential equations, \
so manual solution is not required except for examination of the theory in \
detail."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{613, 687},
WindowMargins->{{71, Automatic}, {Automatic, 12}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 101, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1880, 57, 1179, 30, 197, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3084, 91, 105, 2, 56, "Section",
  Evaluatable->False],
Cell[3192, 95, 1170, 27, 267, "Text",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[4399, 127, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[4504, 131, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4670, 138, 675, 18, 29, "Input"],
Cell[5348, 158, 574, 15, 29, "Output"]
}, Closed]],
Cell[5937, 176, 121, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6083, 182, 75, 2, 27, "Input"],
Cell[6161, 186, 38, 1, 27, "Output"]
}, Closed]],
Cell[6214, 190, 113, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6352, 196, 111, 2, 27, "Input"],
Cell[6466, 200, 59, 1, 29, "Output"]
}, Closed]],
Cell[6540, 204, 118, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6683, 210, 82, 2, 27, "Input"],
Cell[6768, 214, 84, 1, 27, "Output"]
}, Closed]],
Cell[6867, 218, 93, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6985, 224, 95, 2, 27, "Input"],
Cell[7083, 228, 48, 1, 27, "Output"]
}, Closed]],
Cell[7146, 232, 105, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7276, 238, 91, 2, 28, "Input"],
Cell[7370, 242, 61, 1, 42, "Output"]
}, Closed]],
Cell[7446, 246, 94, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7565, 252, 85, 2, 27, "Input"],
Cell[7653, 256, 38, 1, 27, "Output"]
}, Closed]],
Cell[7706, 260, 158, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7889, 271, 91, 2, 27, "Input"],
Cell[7983, 275, 84, 1, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8116, 282, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[8221, 286, 141, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8387, 293, 896, 24, 29, "Input"],
Cell[9286, 319, 788, 21, 29, "Output"]
}, Closed]],
Cell[10089, 343, 121, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10235, 349, 75, 2, 27, "Input"],
Cell[10313, 353, 38, 1, 27, "Output"]
}, Closed]],
Cell[10366, 357, 113, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10504, 363, 111, 2, 27, "Input"],
Cell[10618, 367, 76, 1, 29, "Output"]
}, Closed]],
Cell[10709, 371, 109, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10843, 377, 82, 2, 27, "Input"],
Cell[10928, 381, 120, 2, 27, "Output"]
}, Closed]],
Cell[11063, 386, 93, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11181, 392, 95, 2, 27, "Input"],
Cell[11279, 396, 61, 1, 27, "Output"]
}, Closed]],
Cell[11355, 400, 155, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11535, 408, 114, 2, 31, "Input"],
Cell[11652, 412, 105, 2, 42, "Output"]
}, Closed]],
Cell[11772, 417, 94, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11891, 423, 85, 2, 27, "Input"],
Cell[11979, 427, 72, 1, 29, "Output"]
}, Closed]],
Cell[12066, 431, 158, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12249, 442, 91, 2, 27, "Input"],
Cell[12343, 446, 153, 4, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12545, 456, 101, 2, 36, "Section",
  Evaluatable->False],
Cell[12649, 460, 140, 5, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12814, 469, 458, 12, 29, "Input"],
Cell[13275, 483, 369, 9, 29, "Output"]
}, Closed]],
Cell[13659, 495, 121, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13805, 501, 75, 2, 27, "Input"],
Cell[13883, 505, 38, 1, 27, "Output"]
}, Closed]],
Cell[13936, 509, 113, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14074, 515, 111, 2, 27, "Input"],
Cell[14188, 519, 50, 1, 29, "Output"]
}, Closed]],
Cell[14253, 523, 118, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14396, 529, 82, 2, 27, "Input"],
Cell[14481, 533, 125, 2, 27, "Output"]
}, Closed]],
Cell[14621, 538, 98, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14744, 544, 163, 4, 27, "Input"],
Cell[14910, 550, 59, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15006, 556, 75, 2, 27, "Input"],
Cell[15084, 560, 40, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15161, 566, 75, 2, 27, "Input"],
Cell[15239, 570, 40, 1, 27, "Output"]
}, Closed]],
Cell[15294, 574, 105, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15424, 580, 117, 2, 27, "Input"],
Cell[15544, 584, 83, 1, 42, "Output"]
}, Closed]],
Cell[15642, 588, 94, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15761, 594, 85, 2, 27, "Input"],
Cell[15849, 598, 38, 1, 27, "Output"]
}, Closed]],
Cell[15902, 602, 138, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16065, 609, 133, 3, 31, "Input"],
Cell[16201, 614, 118, 2, 55, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[16356, 621, 147, 4, 27, "Input"],
Cell[16506, 627, 105, 2, 55, "Output"]
}, Closed]],
Cell[16626, 632, 154, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16805, 643, 91, 2, 27, "Input"],
Cell[16899, 647, 129, 3, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17077, 656, 86, 2, 36, "Section",
  Evaluatable->False],
Cell[17166, 660, 1016, 19, 176, "Text",
  Evaluatable->False]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[17439, 578, 117, 2, 70, "Input"],
Cell[17559, 582, 143, 4, 70, "Output"]
}, Closed]],
Cell[17714, 588, 154, 7, 70, "Text"],

Cell[CellGroupData[{
Cell[17891, 597, 91, 2, 70, "Input"],
Cell[17985, 601, 159, 4, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18185, 607, 86, 2, 70, "Section"],
Cell[18274, 611, 1022, 19, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
